define([
    'backbone',
    'Layout',
    'modules/new-appointment-request/views/requests/layout-view',
    'modules/new-appointment-request/resources/request/model',
], function(Backbone, Layout, RequestDetailsLayoutView, RequestModel) {
    'use strict';

    describe('Request Details Layout View', function() {
        var view;
        var $view;
        var layout;


        beforeEach(function() {
            layout = new Layout();
            layout.render();
            spyOn(RequestDetailsLayoutView.prototype, 'showTypePurposeAndDateTimeSectionViews');
            spyOn(RequestDetailsLayoutView.prototype, 'showExpressCareReasonSectionView');
            spyOn(RequestDetailsLayoutView.prototype, 'showPhoneContactSectionView');
            spyOn(RequestDetailsLayoutView.prototype, 'showNewMessageSectionView');
        });


        describe('Sections ', function() {
            beforeEach(function() {
                view = new RequestDetailsLayoutView({
                    model: new RequestModel({
                        appointmentType: 'PRIMARY CARE',
                        typeOfCare: new Backbone.Model({id: '323'}),
                    }),
                });

                layout.showChildView('content', view);
                $view = view.$el;
            });

            it('has regions to show form sections', function() {
                expect($view.has(view.regions.typePurposeRegion).length).toEqual(1);
                expect($view.has(view.regions.dateTimeRegion).length).toEqual(1);
                expect($view.has(view.regions.phoneContactRegion).length).toEqual(1);
                expect($view.has(view.regions.newMessageRegion).length).toEqual(1);
            });
        });

        describe('when type of care is Express Care', function() {
            beforeEach(function() {
                view = new RequestDetailsLayoutView({
                    model: new RequestModel({
                        appointmentType: 'EXPRESS CARE',
                        typeOfCare: new Backbone.Model({id: 'CR1'}),
                    }),
                });

                layout.showChildView('content', view);
                $view = view.$el;
            });

            it('shows appointment type in heading', function() {
                expect($view.find('#request-details').text()).toEqual('Request Details - EXPRESS CARE');
            });

            it('shows reason for visit, phone contact, and new message sections', function() {
                expect(view.showTypePurposeAndDateTimeSectionViews).not.toHaveBeenCalled();
                expect(view.showExpressCareReasonSectionView).toHaveBeenCalled();
                expect(view.showPhoneContactSectionView).toHaveBeenCalled();
                expect(view.showNewMessageSectionView).toHaveBeenCalled();
            });
        });

        describe('when type of care id is not Express Care', function() {
            beforeEach(function() {
                view = new RequestDetailsLayoutView({
                    model: new RequestModel({
                        appointmentType: 'PRIMARY CARE',
                        typeOfCare: new Backbone.Model({id: '323'}),
                    }),
                });

                layout.showChildView('content', view);
                $view = view.$el;
            });

            it('does not show appointment type in heading', function() {
                expect($view.find('#request-details').text()).toEqual('Request Details');
            });

            it('shows type of visit, purpose of visit, date-time, phone contact, and new message sections', function() {
                expect(view.showTypePurposeAndDateTimeSectionViews).toHaveBeenCalled();
                expect(view.showExpressCareReasonSectionView).not.toHaveBeenCalled();
                expect(view.showPhoneContactSectionView).toHaveBeenCalled();
                expect(view.showNewMessageSectionView).toHaveBeenCalled();
            });
        });
    });
});
